<?php
// Koneksi ke database
require 'koneksi.php';
require 'header1.php';

if (!isset($_SESSION['level']) || $_SESSION['level'] == "") {
    header("location: login.php");
    exit;
}

// Proses hapus data jika ada parameter 'hapus' di URL
if (isset($_GET['hapus'])) {
    $id_hapus = intval($_GET['hapus']);

    // Hapus dari tabel mahasiswa berdasarkan ID
    $deleteMahasiswa = mysqli_query($conn, "DELETE FROM mahasiswa WHERE id = '$id_hapus'");

    if ($deleteMahasiswa) {
        echo "<script>
                alert('Data berhasil dihapus!');
                window.location = 'penilaian1.php';
              </script>";
    } else {
        echo "<script>alert('Gagal menghapus data!');</script>";
    }
}

// Ambil data dari tabel mahasiswa
$nilai = query("SELECT * FROM mahasiswa ORDER BY id");

?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-4">
            <h2 class="text-center mb-4 py-4 bg-light rounded" style="font-size: 28px; font-weight: bold;">
                PENILAIAN ALTERNATIF
            </h2>
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center" style="font-size: 20px;">
                <span><i class="fas fa-table"></i> Data Penilaian Mahasiswa</span>
                <a href="tambah_mahasiswa.php" class="btn btn-light btn-sm">
                    <i class="fas fa-plus"></i> Tambah Data Mahasiswa
                </a>
            </div>

            <div class="table-responsive w-100">
                <table id="datatablesSimple" class="table table-striped table-bordered table-hover w-100" style="font-size: 20px;">
                    <thead class="table-primary text-center align-middle">
                        <tr>
                            <th style="width: 3%;">No.</th>
                            <th style="width: 10%;">Nama Alternatif</th>
                            <th style="width: 15%;">Nama Mahasiswa</th>
                            <th style="width: 8%;">Relevansi Konten</th>
                            <th style="width: 8%;">Kualitas Penyampaian</th>
                            <th style="width: 8%;">Kualitas Audiovisual</th>
                            <th style="width: 8%;">Interaktivitas & Engagement</th>
                            <th style="width: 8%;">Frekuensi Penggunaan</th>
                            <th style="width: 8%;">Hambatan Akses</th>
                            <th style="width: 8%;">Dampak terhadap Pemahaman</th>
                            <th style="width: 8%;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="text-center">
                        <?php $i = 1; ?>
                        <?php foreach ($nilai as $row) : ?>
                            <tr style="height: 35px;">
                                <td class="align-middle"><?= $i; ?></td>
                                <td class="align-middle text-center"><?= htmlspecialchars($row["alternatif"]); ?></td>
                                <td class="align-middle text-center"><?= htmlspecialchars($row["nama"]); ?></td>
                                <td class="align-middle text-center"><?= $row["c1"]; ?></td>
                                <td class="align-middle text-center"><?= $row["c2"]; ?></td>
                                <td class="align-middle text-center"><?= $row["c3"]; ?></td>
                                <td class="align-middle text-center"><?= $row["c4"]; ?></td>
                                <td class="align-middle text-center"><?= $row["c5"]; ?></td>
                                <td class="align-middle text-center"><?= $row["c6"]; ?></td>
                                <td class="align-middle text-center"><?= $row["c7"]; ?></td>
                                <td class="align-middle text-center">
                                    <div class="d-flex justify-content-center gap-2">
                                        <a href="ubah_penilaian1.php?id=<?= $row['id']; ?>" class="btn btn-warning btn-sm">
                                            <i class="fas fa-edit"></i> Ubah
                                        </a>
                                        <a href="penilaian1.php?hapus=<?= $row['id']; ?>" 
                                            class="btn btn-danger btn-sm" 
                                            onclick="return confirm('Yakin ingin menghapus?');">
                                                <i class="fas fa-trash-alt"></i> Hapus
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php $i++; ?>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        let spkToggle = document.querySelector("#spkToggle");
        let collapseSPK = document.querySelector("#collapseSPK");

        if (sidebarToggle) {
            sidebarToggle.addEventListener("click", function (e) {
                e.preventDefault();
                document.body.classList.toggle("sb-sidenav-toggled");
            });
        }

        if (spkToggle) {
            spkToggle.addEventListener("click", function (e) {
                e.preventDefault();
                let isExpanded = collapseSPK.classList.contains("show");
                collapseSPK.classList.toggle("show", !isExpanded);
                spkToggle.setAttribute("aria-expanded", !isExpanded);
            });
        }

        let navLinks = document.querySelectorAll('.nav-link');
        navLinks.forEach(link => {
            link.addEventListener("click", function (event) {
                if (this.getAttribute("href") === "#") {
                    event.preventDefault();
                }
            });
        });
    });
</script>
